/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator.server;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.SingleUseOperator;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.network.InteractionManager;
import dev.terminalmc.clientsort.client.network.handler.CollectResultHandler;
import dev.terminalmc.clientsort.client.order.SortContext;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.client.platform.ClientServices;
import dev.terminalmc.clientsort.network.payload.CollectPayload;
import dev.terminalmc.clientsort.network.payload.SortPayload;
import dev.terminalmc.clientsort.network.payload.StackFillPayload;
import dev.terminalmc.clientsort.network.payload.TransferPayload;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;

public class ServerOperator<T extends Operation>
extends SingleUseOperator<Operation> {
    public ServerOperator(AbstractContainerScreen<?> screen, ContainerScreenHelper<? extends AbstractContainerScreen<?>> screenHelper, Slot originSlot, T operation) {
        super(screen, screenHelper, originSlot, operation);
    }

    @Override
    protected void sort(SortOrder sortOrder) {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation SORT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        CollectResultHandler.onSuccess = () -> {
            ServerOperator<Operation> sorter = new ServerOperator<Operation>(this.screen, this.screenHelper, this.originSlot, Operation.SORT);
            int[] slotMapping = sorter.createSlotMapping(sortOrder);
            InteractionManager.now(() -> {
                if (ClientSort.debug()) {
                    ClientSort.LOG.info("Sending payload for operation SORT", new Object[0]);
                }
                ClientServices.PLATFORM.sendToServer(new SortPayload(this.screen.getMenu().containerId, slotMapping));
                return InteractionManager.TICK_WAITER;
            });
        };
        int[] scopeArray = this.createSlotIdArray(this.originScopeSlots);
        this.sendCollectPayload(scopeArray);
    }

    @Override
    protected void fillStacks() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation STACK_FILL: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation STACK_FILL: other scope is empty!", new Object[0]);
            }
            return;
        }
        int[] srcSlotIds = this.createSlotIdArray(this.originScopeSlots);
        int[] dstSlotIds = this.createSlotIdArray(this.otherScopeSlots);
        InteractionManager.now(() -> {
            if (ClientSort.debug()) {
                ClientSort.LOG.info("Sending payload for operation STACK_FILL", new Object[0]);
            }
            ClientServices.PLATFORM.sendToServer(new StackFillPayload(this.screen.getMenu().containerId, srcSlotIds, dstSlotIds));
            return InteractionManager.TICK_WAITER;
        });
    }

    @Override
    protected void transfer() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation TRANSFER: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation TRANSFER: other scope is empty!", new Object[0]);
            }
            return;
        }
        int[] srcSlotIds = this.createSlotIdArray(this.originScopeSlots);
        int[] dstSlotIds = this.createSlotIdArray(this.otherScopeSlots);
        InteractionManager.now(() -> {
            if (ClientSort.debug()) {
                ClientSort.LOG.info("Sending payload for operation TRANSFER", new Object[0]);
            }
            ClientServices.PLATFORM.sendToServer(new TransferPayload(this.screen.getMenu().containerId, srcSlotIds, dstSlotIds));
            return InteractionManager.TICK_WAITER;
        });
    }

    private int[] createSlotIdArray(Slot[] slots) {
        int[] slotIds = new int[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            slotIds[i] = ((ISlot)slots[i]).clientsort$getIdInContainer();
        }
        this.screenHelper.translateSlotIds(slotIds);
        return slotIds;
    }

    private void sendCollectPayload(int[] scopeArray) {
        InteractionManager.now(() -> {
            if (ClientSort.debug()) {
                ClientSort.LOG.info("Sending payload for operation COLLECT", new Object[0]);
            }
            ClientServices.PLATFORM.sendToServer(new CollectPayload(this.screen.getMenu().containerId, scopeArray));
            return InteractionManager.TICK_WAITER;
        });
    }

    private int[] createSlotMapping(SortOrder sortOrder) {
        int[] sortedIds = new int[this.originScopeStacks.length];
        for (int i = 0; i < sortedIds.length; ++i) {
            sortedIds[i] = i;
        }
        sortedIds = sortOrder.sort(sortedIds, this.originScopeStacks, new SortContext((Level)Minecraft.getInstance().level));
        int[] slotMapping = new int[sortedIds.length * 2];
        for (int i = 0; i < sortedIds.length; ++i) {
            Slot from = this.originScopeSlots[sortedIds[i]];
            Slot to = this.originScopeSlots[i];
            slotMapping[i * 2] = ((ISlot)from).clientsort$getIdInContainer();
            slotMapping[i * 2 + 1] = ((ISlot)to).clientsort$getIdInContainer();
        }
        this.screenHelper.translateSlotIds(slotMapping);
        return slotMapping;
    }
}

